-- Define our particle characteristics
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pRadius = Allocate(1); -- Allocate a TReal radius member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member
lifetime = 2400; --particle life time accessed in c++ hiddenobjectgame.cpp.
-- Set the particle texture
SetTexture("spikestar");
SetBlendMode(kBlendAdditiveAlpha);

SetNumParticles(100);    -- Create some particles

--pRadius:Init( fRange(50,51) );
pColor:Init( Color(0,0,0,1) );
pScale:Init( 0.5 );
pAge:Init(0);
pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpinSpeed:Init( fRange( -10, 10 ) );

pPosition:Anim( f2dRotation(pSpin)*pRadius);
--pPosition:Anim( pPosition );
pScale:Anim( pScale + fTimeScale(0.1) );
--pColor:Anim( fFade( pAge,Color(0,1,1,0), 1000, Color(1,1,1,1), 1200, Color(1,1,1,0) ) );

pColor:Anim( 
   fFade( pAge,
     Color(0.1,0.1,1,1), 500, 
     Color(1,1,1,1), 800, 
     Color(1,0.1,0.1,1), 1000, 
     Color(1,1,1,0) ) 
   );
pSpin:Anim( pSpin + fTimeScale( 2 ) );
pUp:Anim( f2dRotation( pSpin ) );
-- Add time to the age
pAge:Anim( pAge+fAge());

-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,2300) ) );-- This should match lifetime value.


gActive = true;
-- A function to run as we're executing
-- seconds - how many seconds have elapsed

function Update(seconds)
   if( gActive ) then 
      CreateParticles( 100 );   
   end    
   gActive = false;
end
